/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.ChooseFileEditorScreen;
import com.quantumdata.quantumdatasdk.InputPathScreen;
import com.quantumdata.quantumdatasdk.InstallationScreen;
import com.quantumdata.quantumdatasdk.MainScreen;
import com.quantumdata.quantumdatasdk.QuantumDataSDK;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ScreenManager
implements ActionListener {
    private static final String sCommandNext = "NEXT";
    private static final String sCommandPrev = "PREVIOUS";
    private static final String sCommandCancel = "CANCEL";
    private JPanel cardPanel;
    private CardLayout aCardLayout;
    private JFrame aFrame;
    private InputPathScreen aInputPathScreen;
    private ChooseFileEditorScreen aChooseFileEditorScreen;
    private InstallationScreen aInstallationScreen;
    private MainScreen aMainScreen;
    private JButton lPrevButton;
    private JButton lNextButton;
    private JButton lCancelButton;
    final int NCARDS = 4;
    String[] cardLabels = new String[4];
    static int currentCardIndex = 0;

    public void addComponentToPane(Container container) {
        this.cardLabels[0] = "Input SDK Path";
        this.cardLabels[1] = "Choose File Editor";
        this.cardLabels[2] = "Installation";
        this.lPrevButton = new JButton("< Prev");
        this.lPrevButton.setVerticalTextPosition(0);
        this.lPrevButton.setHorizontalTextPosition(10);
        this.lPrevButton.setMnemonic('P');
        this.lPrevButton.setActionCommand(sCommandPrev);
        this.lPrevButton.addActionListener(this);
        this.lPrevButton.setEnabled(false);
        this.lNextButton = new JButton("Next >");
        this.lNextButton.setVerticalTextPosition(0);
        this.lNextButton.setHorizontalTextPosition(10);
        this.lNextButton.setMnemonic('N');
        this.lNextButton.setActionCommand(sCommandNext);
        this.lNextButton.addActionListener(this);
        this.lNextButton.setDefaultCapable(true);
        this.lCancelButton = new JButton("Cancel");
        this.lCancelButton.setVerticalTextPosition(0);
        this.lCancelButton.setHorizontalTextPosition(10);
        this.lCancelButton.setMnemonic('C');
        this.lCancelButton.setActionCommand(sCommandCancel);
        this.lCancelButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.lPrevButton);
        jPanel.add(this.lNextButton);
        jPanel.add(this.lCancelButton);
        this.aInputPathScreen = new InputPathScreen(this);
        this.aChooseFileEditorScreen = new ChooseFileEditorScreen(this);
        this.aInstallationScreen = new InstallationScreen(this, this.aFrame);
        this.aCardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.aCardLayout);
        this.cardPanel.add((Component)this.aInputPathScreen, this.cardLabels[0]);
        this.cardPanel.add((Component)this.aChooseFileEditorScreen, this.cardLabels[1]);
        this.cardPanel.add((Component)this.aInstallationScreen, this.cardLabels[2]);
        Box box = new Box(1);
        box.add(Box.createVerticalGlue());
        box.add(this.cardPanel);
        box.add(Box.createVerticalGlue());
        container.add((Component)jPanel, "South");
        container.add(box);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.lPrevButton)) {
            if (currentCardIndex % 4 == 0) {
                String string = "There is no \"Previous\" step!";
                JOptionPane.showMessageDialog(null, string, "Invalid Button Press", 0);
            } else {
                this.aCardLayout.show(this.cardPanel, this.cardLabels[--currentCardIndex]);
            }
        } else if (actionEvent.getSource().equals(this.lNextButton)) {
            if (currentCardIndex % 4 == 0 && !this.aInputPathScreen.isPathValid()) {
                String string = "Please input a valid path!";
                JOptionPane.showMessageDialog(null, string, "Invalid Path", 0);
            } else if (currentCardIndex % 4 == 1 && this.aChooseFileEditorScreen.invalidEditor()) {
                String string = "Please select a valid file editor!";
                JOptionPane.showMessageDialog(null, string, "Invalid File Editor", 0);
            } else if (currentCardIndex % 4 == 2) {
                this.jumpToMainScreen();
            } else {
                if (currentCardIndex % 4 == 1) {
                    this.lPrevButton.setEnabled(false);
                    this.lNextButton.setEnabled(false);
                    this.aInstallationScreen.run();
                } else {
                    this.lPrevButton.setEnabled(true);
                }
                this.aCardLayout.show(this.cardPanel, this.cardLabels[++currentCardIndex]);
            }
        } else if (actionEvent.getSource().equals(this.lCancelButton)) {
            QuantumDataSDK.ExitApp();
        } else if (actionEvent.getActionCommand().equals("DONE")) {
            this.jumpToMainScreen();
        } else if (actionEvent.getActionCommand().equals("JUMPTOMAIN")) {
            this.jumpToMainScreen();
        } else {
            this.aMainScreen.actionPerformed(actionEvent);
        }
    }

    private void jumpToMainScreen() {
        this.aFrame.setVisible(false);
        this.aMainScreen = new MainScreen(this);
    }

    public void run() {
        this.aFrame = new JFrame("Quantum Data SDK Setup");
        this.aFrame.setDefaultCloseOperation(3);
        this.addComponentToPane(this.aFrame.getContentPane());
        this.aFrame.pack();
        this.aFrame.setLocationRelativeTo(null);
        this.aFrame.setVisible(true);
    }
}

